;;; 
;;; Virtual Disk Drive Project	- Sep 16, 2001 - EJR (in Austin)
;;;
;;; ** Fri Jan 04 15:30:36 2002 **

#include <vd.h>
#include <track.h>
#include "utility.h"
#include "hardware.h"

;;;
;;; This routine exports the following symbols
;;; 
   global	DiskSetCopy         ; copies one working set to another
   global	DiskActivate        ; activates the given disk
   global	DiskSetSetup        ; Initialize the Disk sets
		
PROG1	 CODE

;;;*******************************************************************
;;; NAME:	DiskTable()
;;;
;;; DESCR:	THIS ROUTINE IS IN main.asm TO PUT IT IN A KNOWN PAGE.
;;;
;;; ARGS:	
;;;
;;; RETURNS:	
;;;
;;; NOTES:	(see main.asm)
;;;*******************************************************************

;;;*******************************************************************
;;; NAME:	DiskSetSetup()
;;;
;;; DESCR:	Initialize the disk sets.
;;;
;;; ARGS:	
;;;
;;; RETURNS:	
;;;
;;; NOTES:	
;;;*******************************************************************
DiskSetSetup:
		movlw	NULLDISK
		movwf	CURDISK
		return
		
;;;*******************************************************************
;;; NAME:	DiskSetCopy()
;;;
;;; DESCR:	Copies one disk set to another.
;;;
;;; ARGS:	ARG0 --> From
;;;		ARG1 --> To
;;;		DSET0 is used (for decrementing count of bytes)
;;;		DSET1 is used (for byte to be transferred)
;;;
;;; RETURNS:	ARG0 and ARG1 have moved
;;;
;;; NOTES:	- DISKSETBYTES can't be 0 or this will copy 256 bytes
;;;		  (or at least try to)
;;;*******************************************************************
DiskSetCopy:
		movlw	DISKSETBYTES
		movwf	DSET0

DiskSet1:
		movf	ARG0,W
		movwf	FSR
		movf	INDF,W		; got the byte to be copied
		movwf	DSET1		; save byte for later
		movf	ARG1,W
		movwf	FSR
		movf	DSET1,W
		movwf	INDF		; write that byte

		incf	ARG0		; bump addresses along
		incf	ARG1		;    (loads W to save a cycle)
		decfsz	DSET0		; decrement byte count
		goto	DiskSet1

		return

;;;*******************************************************************
;;; NAME:	DiskActivate()
;;;
;;; DESCR:	"Activates" the given disk.  If it is already active,
;;;		a copy from the working disk to the given disk is
;;;		performed...effecting a "checkpoint".  (this is actually
;;;		used when originally loading or reloading a disk)
;;;
;;; ARGS:	W has disk to activate (DISK0 or DISK1)
;;;		DSET2 is used (DSET0 and DSET1 used by DiskSetCopy)
;;; 
;;; RETURNS:	
;;;
;;; NOTES:	- an activate of the same disk checkpoints the disk
;;;*******************************************************************
DiskActivate:
		movwf	DSET2		; save disk to activate

	;; copy the currently active disk back to storage
	
		movf	CURDISK,W
		movwf	ARG1		; set "to"
		movlw	ACTIVEDISK
		movwf	ARG0		; prepared for active save
		call	DiskSetCopy
	
	;; copy the target disk to the working disk
DA2:	
		movf	DSET2, W		
		movwf	ARG0
		movlw	ACTIVEDISK
		movwf	ARG1
		call	DiskSetCopy

	;; now ensure that the address lines reflect this disk

		MemAddrSet
	
		return		
;;; =======================================================================
;;; =======================================================================

	END
